<?php

namespace App\Controllers\Api;

use App\Controllers\BaseController;
use App\Models\DbipCityIpv4Model;
use CodeIgniter\HTTP\ResponseInterface;

class Dbip extends BaseController
{
    /**
     * GET api/dbip?ip=1.0.0.1
     * Returns DB-IP city IPv4 data for the given IPv4 address.
     */
    public function index(): ResponseInterface
    {
        $ip = $this->request->getGet('ip');

        if ($ip === null || $ip === '') {
            return $this->response
                ->setJSON([
                    'success' => false,
                    'error'   => 'Missing parameter: ip',
                ])
                ->setStatusCode(400);
        }

        $ip = trim($ip);

        if (! filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)) {
            return $this->response
                ->setJSON([
                    'success' => false,
                    'error'   => 'Invalid IPv4 address',
                ])
                ->setStatusCode(400);
        }

        $model = model(DbipCityIpv4Model::class);
        $row  = $model->findByIp($ip);

        if ($row === null) {
            return $this->response
                ->setJSON([
                    'success' => false,
                    'error'   => 'No DB-IP data found for this IP',
                    'ip'      => $ip,
                ])
                ->setStatusCode(404);
        }

        return $this->response->setJSON([
            'success' => true,
            'ip'      => $ip,
            'source'  => 'dbip_city_ipv4',
            'data'    => $row,
        ]);
    }
}
