<?php

namespace App\Controllers\Api;

use App\Controllers\BaseController;
use App\Models\GeolocationModel;
use CodeIgniter\HTTP\ResponseInterface;

class Geolocation extends BaseController
{
    /**
     * GET api/geolocation?ip=1.0.0.1
     * Returns geolocation data for the given IPv4 address.
     */
    public function index(): ResponseInterface
    {
        $ip = $this->request->getGet('ip');

        if ($ip === null || $ip === '') {
            return $this->response
                ->setJSON([
                    'success' => false,
                    'error'   => 'Missing parameter: ip',
                ])
                ->setStatusCode(400);
        }

        $ip = trim($ip);

        if (! filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)) {
            return $this->response
                ->setJSON([
                    'success' => false,
                    'error'   => 'Invalid IPv4 address',
                ])
                ->setStatusCode(400);
        }

        $model = model(GeolocationModel::class);
        $row  = $model->findByIp($ip);

        if ($row === null) {
            return $this->response
                ->setJSON([
                    'success' => false,
                    'error'   => 'No geolocation data found for this IP',
                    'ip'      => $ip,
                ])
                ->setStatusCode(404);
        }

        return $this->response->setJSON([
            'success' => true,
            'ip'      => $ip,
            'data'    => $row,
        ]);
    }
}
