<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateIp2locationLiteDb11Table extends Migration
{
    public function up(): void
    {
        $this->forge->addField([
            'id'           => ['type' => 'INT', 'constraint' => 11, 'unsigned' => true, 'auto_increment' => true],
            'ip_from'      => ['type' => 'BIGINT', 'null' => false],
            'ip_to'        => ['type' => 'BIGINT', 'null' => false],
            'country_code' => ['type' => 'CHAR', 'constraint' => 2, 'null' => true],
            'country_name' => ['type' => 'VARCHAR', 'constraint' => 100, 'null' => true],
            'region'       => ['type' => 'VARCHAR', 'constraint' => 100, 'null' => true],
            'city'         => ['type' => 'VARCHAR', 'constraint' => 100, 'null' => true],
            'latitude'     => ['type' => 'DECIMAL', 'constraint' => '10,8', 'null' => true],
            'longitude'    => ['type' => 'DECIMAL', 'constraint' => '11,8', 'null' => true],
            'zip_code'     => ['type' => 'VARCHAR', 'constraint' => 20, 'null' => true],
            'time_zone'    => ['type' => 'VARCHAR', 'constraint' => 50, 'null' => true],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addKey(['ip_from', 'ip_to']);
        $this->forge->createTable('ip2location_lite_db11');
    }

    public function down(): void
    {
        $this->forge->dropTable('ip2location_lite_db11');
    }
}
