<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateDbipCityIpv4Table extends Migration
{
    public function up(): void
    {
        $this->forge->addField([
            'id'           => ['type' => 'INT', 'constraint' => 11, 'unsigned' => true, 'auto_increment' => true],
            'start_ip'    => ['type' => 'VARCHAR', 'constraint' => 15, 'null' => false],
            'end_ip'       => ['type' => 'VARCHAR', 'constraint' => 15, 'null' => false],
            'country_code' => ['type' => 'CHAR', 'constraint' => 2, 'null' => true],
            'region'       => ['type' => 'VARCHAR', 'constraint' => 100, 'null' => true],
            'city'         => ['type' => 'VARCHAR', 'constraint' => 100, 'null' => true],
            'latitude'     => ['type' => 'DECIMAL', 'constraint' => '10,8', 'null' => true],
            'longitude'    => ['type' => 'DECIMAL', 'constraint' => '11,8', 'null' => true],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addKey(['start_ip', 'end_ip']);
        $this->forge->createTable('dbip_city_ipv4');
    }

    public function down(): void
    {
        $this->forge->dropTable('dbip_city_ipv4');
    }
}
